<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../classi/GestoreHtaccess.php";
    include "../classi/GeneratoreUrl.php";
    
    session_start();
    controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
    
    // i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    }

    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 2) ;
    $percorsoGeecomAdmin = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'aggiornaCampoTabella':
            $tabella = filter_input(INPUT_GET,"tabella",FILTER_SANITIZE_ADD_SLASHES);
            $id      = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
            $campo   = filter_input(INPUT_GET,"campo",FILTER_SANITIZE_ADD_SLASHES);
            $valore  = filter_input(INPUT_GET,"valore",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE $tabella SET $campo='$valore' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'aggiornaImpostazioniGenerali':
            $nomePiattaforma        = filter_input(INPUT_POST,"nomePiattaforma",FILTER_SANITIZE_ADD_SLASHES);
            $descrizioneSito        = filter_input(INPUT_POST,"descrizioneSito",FILTER_SANITIZE_ADD_SLASHES);
            $urlPiattaforma         = filter_input(INPUT_POST,"urlPiattaforma",FILTER_SANITIZE_ADD_SLASHES);
            $mostraProfilo          = filter_input(INPUT_POST,"mostraProfilo",FILTER_SANITIZE_ADD_SLASHES);
            $disattivaAccessoUtenti = filter_input(INPUT_POST,"disattivaAccessoUtenti",FILTER_SANITIZE_ADD_SLASHES);
            $messaggioAccessoDisattivato = filter_input(INPUT_POST,"messaggioAccessoDisattivato",FILTER_SANITIZE_ADD_SLASHES);
            $paginaLogin            = filter_input(INPUT_POST,"paginaLogin",FILTER_SANITIZE_NUMBER_INT);
            $homePage               = filter_input(INPUT_POST,"homePage",FILTER_SANITIZE_NUMBER_INT);
            $paginaProfilo          = filter_input(INPUT_POST,"paginaProfilo",FILTER_SANITIZE_NUMBER_INT);
            $paginaRecuperoPassword = filter_input(INPUT_POST,"paginaRecuperoPassword",FILTER_SANITIZE_NUMBER_INT);
            $tipoRedirectLogin      = filter_input(INPUT_POST,"tipoRedirectLogin",FILTER_SANITIZE_ADD_SLASHES);
            $linkPersonalizzatoLogin= filter_input(INPUT_POST,"linkPersonalizzatoLogin",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE geecAd_impostazioni SET nomePiattaforma='$nomePiattaforma', descrizioneSito='$descrizioneSito', urlPiattaforma='$urlPiattaforma', disattivaAccessoUtenti='$disattivaAccessoUtenti', messaggioAccessoDisattivato='$messaggioAccessoDisattivato', tipoRedirectLogin='$tipoRedirectLogin', linkPersonalizzatoLogin='$linkPersonalizzatoLogin', mostraProfilo='$mostraProfilo', paginaLogin='$paginaLogin', homePage=$homePage, paginaProfilo='$paginaProfilo', paginaRecuperoPassword='$paginaRecuperoPassword' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=200");
            break;
        case 'aggiornaImpostazioniNotifiche':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $mailNotifiche = filter_input(INPUT_POST,"mailNotifiche",FILTER_SANITIZE_ADD_SLASHES);
            $inviaNotificaMailNuovoUtente        = filter_input(INPUT_POST,"inviaNotificaMailNuovoUtente",FILTER_SANITIZE_URL);
            $inviaNotificaMailNuoveComunicazioni = filter_input(INPUT_POST,"inviaNotificaMailNuoveComunicazioni",FILTER_SANITIZE_URL);

            $queryAggiornamentoDati ="UPDATE geecAd_impostazioni SET mailNotifiche='$mailNotifiche', inviaNotificaMailNuovoUtente='$inviaNotificaMailNuovoUtente', inviaNotificaMailNuoveComunicazioni='$inviaNotificaMailNuoveComunicazioni' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoDati);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=265");
            break;
        case 'aggiornaProfiliSocial':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $facebook  = filter_input(INPUT_POST,"facebook",FILTER_SANITIZE_URL);
            $instagram = filter_input(INPUT_POST,"instagram",FILTER_SANITIZE_URL);
            $twitter   = filter_input(INPUT_POST,"twitter",FILTER_SANITIZE_URL);
            $linkedin  = filter_input(INPUT_POST,"linkedin",FILTER_SANITIZE_URL);
            $youtube   = filter_input(INPUT_POST,"youtube",FILTER_SANITIZE_URL);
            $patreon   = filter_input(INPUT_POST,"patreon",FILTER_SANITIZE_URL);
            $ticToc    = filter_input(INPUT_POST,"ticToc",FILTER_SANITIZE_URL);
            $whatsapp  = filter_input(INPUT_POST,"whatsapp",FILTER_SANITIZE_ADD_SLASHES);
            $mostraChatWhatsapp = filter_input(INPUT_POST,"mostraChatWhatsapp",FILTER_SANITIZE_ADD_SLASHES);
            $telegram           = filter_input(INPUT_POST,"telegram",FILTER_SANITIZE_URL);
            $mostraChatTelegram = filter_input(INPUT_POST,"mostraChatTelegram",FILTER_SANITIZE_ADD_SLASHES);

            $queryAggiornamentoDati ="UPDATE geec_profiliSocial SET facebook='$facebook', twitter='$twitter', linkedin='$linkedin', youtube='$youtube', patreon='$patreon', ticToc='$ticToc', instagram='$instagram', whatsapp='$whatsapp', mostraChatWhatsapp='$mostraChatWhatsapp', telegram='$telegram', mostraChatTelegram='$mostraChatTelegram'  WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoDati);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=245");
            break;
        case 'aggiornaImpostazioniRegistrazione':
            // aggiorno i dati del modulo registrazione
            $richiediNome           = filter_input(INPUT_POST, "richiediNome",FILTER_SANITIZE_ADD_SLASHES);
            $richiediCognome        = filter_input(INPUT_POST, "richiediCognome",FILTER_SANITIZE_ADD_SLASHES);
            $richiediCitta          = filter_input(INPUT_POST, "richiediCitta",FILTER_SANITIZE_ADD_SLASHES);
            $richiediCodiceFiscale  = filter_input(INPUT_POST, "richiediCodiceFiscale",FILTER_SANITIZE_ADD_SLASHES);
            $richiediPartitaIva     = filter_input(INPUT_POST, "richiediPartitaIva",FILTER_SANITIZE_ADD_SLASHES);
            $richiediTelefono       = filter_input(INPUT_POST, "richiediTelefono",FILTER_SANITIZE_ADD_SLASHES);
            $richiediEmail          = filter_input(INPUT_POST, "richiediEmail",FILTER_SANITIZE_ADD_SLASHES);
            $richiediPassword       = filter_input(INPUT_POST, "richiediPassword",FILTER_SANITIZE_ADD_SLASHES);
            $richiediOrganizzazione = filter_input(INPUT_POST, "richiediOrganizzazione",FILTER_SANITIZE_ADD_SLASHES);
            $richiediGruppo         = filter_input(INPUT_POST, "richiediGruppo",FILTER_SANITIZE_ADD_SLASHES);
            $gruppoObbligatorio     = filter_input(INPUT_POST, "gruppoObbligatorio",FILTER_SANITIZE_ADD_SLASHES);
            $inviaPasswordViaEmail  = filter_input(INPUT_POST, "inviaPasswordViaEmail",FILTER_SANITIZE_ADD_SLASHES);
            $testoRegistrazione     = filter_input(INPUT_POST, "contenutoEmailRegistrazione",FILTER_SANITIZE_ADD_SLASHES);
            $inviaMailConferma      = filter_input(INPUT_POST, "inviaMailConferma",FILTER_SANITIZE_ADD_SLASHES);
            
            $queryAggiornamento     = "UPDATE geecAd_moduliRegistrazione SET richiediNome='$richiediNome', richiediCognome='$richiediCognome', richiediCitta='$richiediCitta', richiediCodiceFiscale='$richiediCodiceFiscale', richiediPartitaIva='$richiediPartitaIva', richiediTelefono='$richiediTelefono', richiediEmail='$richiediEmail', richiediPassword='$richiediPassword', richiediGruppo='$richiediGruppo', gruppoObbligatorio='$gruppoObbligatorio', inviaPasswordViaEmail='$inviaPasswordViaEmail', contenutoEmailRegistrazione='$testoRegistrazione', richiediOrganizzazione='$richiediOrganizzazione', inviaMailConferma='$inviaMailConferma' WHERE id=1";
            $risImpostazioniFooter  = $geecomDb->eseguiQueryScrittura($queryAggiornamento);

            $registrazioneUtenti   = filter_input(INPUT_POST,"registrazioneUtenti",FILTER_SANITIZE_ADD_SLASHES);
            $gruppoDefault         = filter_input(INPUT_POST,"gruppoDefault",FILTER_SANITIZE_ADD_SLASHES);
            $statoInizialeNuoviUtenti = filter_input(INPUT_POST,"statoInizialeNuoviUtenti",FILTER_SANITIZE_ADD_SLASHES);
            $accessoFacebook       = filter_input(INPUT_POST,"accessoFacebook",FILTER_SANITIZE_ADD_SLASHES);
            $accessoGoogle         = filter_input(INPUT_POST,"accessoGoogle",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE geecAd_impostazioni SET registrazioneUtenti='$registrazioneUtenti', gruppoDefault='$gruppoDefault', statoInizialeNuoviUtenti='$statoInizialeNuoviUtenti', accessoFacebook='$accessoFacebook', accessoGoogle='$accessoGoogle'  WHERE id=1";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=210");
            break;
        case 'aggiornaImpostazioniContabilita':
            
            $attivaContabilita = filter_input(INPUT_POST,"attivaContabilita",FILTER_SANITIZE_ADD_SLASHES);
            $tipoContabilita   = filter_input(INPUT_POST,"tipoContabilita",FILTER_SANITIZE_ADD_SLASHES);
            $percentualeIva    = filter_input(INPUT_POST,"percentualeIva",FILTER_SANITIZE_NUMBER_INT);
            $gruppoClienti     = filter_input(INPUT_POST,"gruppoClienti",FILTER_SANITIZE_NUMBER_INT);
            $gruppoFornitori   = filter_input(INPUT_POST,"gruppoFornitori",FILTER_SANITIZE_NUMBER_INT);
            $intestazioneDocumentiFiscali = filter_input(INPUT_POST,"intestazioneDocumentiFiscali",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE geecAd_impostazioni SET attivaContabilita='$attivaContabilita', percentualeIva='$percentualeIva', gruppoClienti='$gruppoClienti', gruppoFornitori='$gruppoFornitori', intestazioneDocumentiFiscali='$intestazioneDocumentiFiscali', tipoContabilita='$tipoContabilita' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=220");
            break;
        case 'aggiornaImpostazioniLingue':    
            $impostazioniItaliano  = $geecomDb->escapeString($_POST['impostazioniItaliano']);
            $menuItaliano = $geecomDb->escapeString($_POST['menuItaliano']);
            $homePage = $geecomDb->escapeString($_POST['homePageItaliano']);

            $impostazioniInglese  = $geecomDb->escapeString($_POST['impostazioniInglese']);
            $menuInglese = $geecomDb->escapeString($_POST['menuInglese']);
            $homePageEn = $geecomDb->escapeString($_POST['homePageInglese']);

            $impostazioniTedesco = $geecomDb->escapeString($_POST['impostazioniTedesco']);
            $menuTedesco         = $geecomDb->escapeString($_POST['menuTedesco']);
            $homePageDe          = $geecomDb->escapeString($_POST['homePageDe']);

            $impostazioniFrancese  = $geecomDb->escapeString($_POST['impostazioniFrancese']);
            $menuFrancese = $geecomDb->escapeString($_POST['menuFrancese']);
            $impostazioniSpagnolo  = $geecomDb->escapeString($_POST['impostazioniSpagnolo']);
            $menuSpagnolo = $geecomDb->escapeString($_POST['menuSpagnolo']);

            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoLingue = "UPDATE geecAd_impostazioniLingue SET impostazioniItaliano='$impostazioniItaliano',menuItaliano='$menuItaliano',impostazioniInglese='$impostazioniInglese',menuInglese='$menuInglese',
    impostazioniTedesco='$impostazioniTedesco', menuTedesco='$menuTedesco', impostazioniFrancese='$impostazioniFrancese',menuFrancese='$menuFrancese',impostazioniSpagnolo='$impostazioniSpagnolo',menuSpagnolo='$menuSpagnolo'
    WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoLingue);

            //aggiorno le impostazioni delle home (attualmente nella tabella impostazioni)
            $queryAggiornamentoImpostazioni = "UPDATE geecAd_impostazioni SET homePage='$homePage', homePageEn='$homePageEn' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoImpostazioni);
            
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=500");
            break;
        case 'aggiornaImpostazioniFooter':
            $idFooter              = filter_input(INPUT_POST,"id", FILTER_SANITIZE_NUMBER_INT);
            $lingua                = filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES);
            $attivaFooterSuperiore = $geecomDb->escapeString($_POST["attivaFooterSuperiore"]);
            $numeroColonne = $geecomDb->escapeString($_POST["numeroColonne"]);
            $colonna1 = $geecomDb->escapeString($_POST["colonna1"]);
            $colonna2 = $geecomDb->escapeString($_POST["colonna2"]);
            $colonna3 = $geecomDb->escapeString($_POST["colonna3"]);
            $colonna4 = $geecomDb->escapeString($_POST["colonna4"]);

            $titoloColonna1 = $geecomDb->escapeString($_POST["titoloColonna1"]);
            $titoloColonna2 = $geecomDb->escapeString($_POST["titoloColonna2"]);
            $titoloColonna3 = $geecomDb->escapeString($_POST["titoloColonna3"]);
            $titoloColonna4 = $geecomDb->escapeString($_POST["titoloColonna4"]);

            $coloreFooterInferiore = filter_input(INPUT_POST,"coloreFooterInferiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreFooterSuperiore = filter_input(INPUT_POST,"coloreFooterSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestiMenu       = filter_input(INPUT_POST,"coloreTestiMenu", FILTER_SANITIZE_ADD_SLASHES);

            $testo= str_replace("../immagini","immagini",$geecomDb->escapeString($_POST["testoFooter"]));

            $queryModificaFooter = "UPDATE geecAd_footer SET attivaFooterSuperiore='$attivaFooterSuperiore', numeroColonne=$numeroColonne, colonna1=$colonna1, colonna2=$colonna2, colonna3=$colonna3, colonna4=$colonna4, titoloColonna1='$titoloColonna1', titoloColonna2='$titoloColonna2', titoloColonna3='$titoloColonna3', titoloColonna4='$titoloColonna4', testo='$testo', coloreFooterInferiore='$coloreFooterInferiore', coloreFooterSuperiore='$coloreFooterSuperiore', coloreTestiMenu='$coloreTestiMenu' WHERE id=$idFooter";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=240&lingua=$lingua");
            break;
        case 'aggiornaImpostazioniBarraMenu':
            $sfondoBarraMenu      = filter_input(INPUT_POST,"sfondoBarraMenu", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestoBarraMenu = filter_input(INPUT_POST,"coloreTestoBarraMenu", FILTER_SANITIZE_ADD_SLASHES);

            $queryModificaBarraMenu = "UPDATE geec_configurazioniAspetto SET sfondoBarraMenu='$sfondoBarraMenu', coloreTestoBarraMenu='$coloreTestoBarraMenu' WHERE selezionataAdmin='si'";
            $geecomDb->eseguiQueryScrittura($queryModificaBarraMenu);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=330");
            break;
        case 'aggiornaImpostazioniBarraSuperiore':
            $coloreBarraSuperiore      = filter_input(INPUT_POST,"coloreBarraSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestoBarraSuperiore = filter_input(INPUT_POST,"coloreTestoBarraSuperiore", FILTER_SANITIZE_ADD_SLASHES);

            $queryModificaBarraMenu = "UPDATE geecAd_impostazioni SET coloreBarraSuperiore='$coloreBarraSuperiore', coloreTestoBarraSuperiore='$coloreTestoBarraSuperiore' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryModificaBarraMenu);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=340");
            break;
        case 'aggiornaTemplateEmail':
            $id         = filter_input(INPUT_POST,"id", FILTER_SANITIZE_NUMBER_INT);
            $nome       = filter_input(INPUT_POST,"nome", FILTER_SANITIZE_ADD_SLASHES);
            $css        = filter_input(INPUT_POST,"css", FILTER_SANITIZE_ADD_SLASHES);
            $corpoMail  = filter_input(INPUT_POST,"corpoMail", FILTER_SANITIZE_ADD_SLASHES);
            $footerMail = filter_input(INPUT_POST,"footerMail", FILTER_SANITIZE_ADD_SLASHES);

            $queryModificaFooter = "UPDATE geec_templateEmail SET nome='$nome', css='$css', corpoMail='$corpoMail', footerMail='$footerMail' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=285&idTemplate=$id");
            break;
        case 'creaTemplateEmail':

            if($_FILES['immagineIntestazione']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
                $gestoreUpload = new GestoreUpload("immagineIntestazione", $tipiFileAmmessi, 8, "../immagini/altro", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        echo("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        echo("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $immagineIntestazione = $impostazioni["urlPiattaforma"]."/".str_replace("../","",$esitoUpload["percorso"]);
                }
            }
            
            if($_FILES['immagineFooter']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg");
                $gestoreUpload = new GestoreUpload("immagineFooter", $tipiFileAmmessi, 8, "../immagini/altro", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        echo("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        echo("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $immagineFooter = $impostazioni["urlPiattaforma"]."/".str_replace("../","",$esitoUpload["percorso"]);
                }
            }

            $immagineCentrata = "<tr>
                            <td align=\"center\">
                                <img src=\"__immagine__\" width=\"220\" height=\"65\" border=\"0\" style=\"border:0; outline:none; text-decoration:none; display:block;\">  
                            </td>
                        </tr>";
            
            $immagineATuttaLarghezza = "<tr>
                            <td align=\"center\">
                                <img src=\"__immagine__\" width=\"516\" height=\"103\" border=\"0\" style=\"border:0; outline:none; text-decoration:none; display:block;\">  
                            </td>
                        </tr>";
            
            $nome       = filter_input(INPUT_POST,"nome", FILTER_SANITIZE_ADD_SLASHES);
            
            $css = filter_input(INPUT_POST,"css", FILTER_SANITIZE_ADD_SLASHES);
            if(isset($_POST["personalizzaColoriTemplateMail"]) && $_POST["personalizzaColoriTemplateMail"]=="si") {
                $coloreSfondoMail       = filter_input(INPUT_POST,"coloreSfondoMail", FILTER_SANITIZE_ADD_SLASHES);
                $coloreIntestazioniMail = filter_input(INPUT_POST,"coloreIntestazioniMail", FILTER_SANITIZE_ADD_SLASHES);
                $coloreLink             = filter_input(INPUT_POST,"coloreLink", FILTER_SANITIZE_ADD_SLASHES);
                $coloreLinkHover        = filter_input(INPUT_POST,"coloreLinkHover", FILTER_SANITIZE_ADD_SLASHES);
                
                // eseguo i replace sostituendo i colori impostati di default con quelli scelti dall'utente
                $css = str_replace("background-color: #f6f6f6","background-color: $coloreSfondoMail",$css);
                $css = str_replace("color: #000000;","color: $coloreIntestazioniMail;",$css);
                $css = str_replace("color: #018394;","color: $coloreLink;",$css);
                $css = str_replace("background-color: #016c7a","background-color: $coloreLinkHover",$css);
            }
            $corpoMail  = filter_input(INPUT_POST,"corpoMail", FILTER_SANITIZE_ADD_SLASHES);
                    
            $tipoIntestazioneTemplateMail = filter_input(INPUT_POST,"tipoIntestazioneTemplateMail", FILTER_SANITIZE_ADD_SLASHES);
            
            if($tipoIntestazioneTemplateMail=="imgCentrata") {
                $intestazioneMail = str_replace("__immagine__",$immagineIntestazione,$immagineCentrata);
            }
            else if($tipoIntestazioneTemplateMail=="imgTuttaLarghezza") {
                $intestazioneMail = str_replace("__immagine__",$immagineIntestazione,$immagineATuttaLarghezza); 
            }
            else { // testo
                $intestazioneMail = filter_input(INPUT_POST,"intestazioneMail", FILTER_SANITIZE_ADD_SLASHES);            
            }
            $corpoMail = str_replace("__intestazione_mail__",$intestazioneMail,$corpoMail);
            
            $tipoFooterTemplateMail = filter_input(INPUT_POST,"tipoFooterTemplateMail", FILTER_SANITIZE_ADD_SLASHES);
            if($tipoFooterTemplateMail=="imgCentrata") {
                $footerMail = str_replace("__immagine__",$immagineFooter,$immagineCentrata);
            }
            else if($tipoFooterTemplateMail=="imgTuttaLarghezza") {
                $footerMail = str_replace("__immagine__",$immagineFooter,$immagineATuttaLarghezza);
            }
            else { // testo
                $footerMail = filter_input(INPUT_POST,"footerMail", FILTER_SANITIZE_ADD_SLASHES);
            }
            
            $queryModificaFooter = "INSERT INTO geec_templateEmail VALUES(NULL,'$nome','$css','$corpoMail','$footerMail')";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            $id = $geecomDb->idUltimoElemento();
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=285&idTemplate=$id");
            break;
        case 'aggiornaImpostazioniInclusioni':
            $inizioHead  = $geecomDb->escapeString($_POST['inizioHead']);
            $fineHead    = $geecomDb->escapeString($_POST['fineHead']);
            $inizioBody  = $geecomDb->escapeString($_POST['inizioBody']);
            $fineBody    = $geecomDb->escapeString($_POST['fineBody']);
            $footer      = $geecomDb->escapeString($_POST['inclusioneFooter']);
            $queryAggiornamentoPaginaContatti = "UPDATE geecAd_inclusioni SET inizioHead='$inizioHead', fineHead='$fineHead', inizioBody='$inizioBody', fineBody='$fineBody', footer='$footer' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=250");
            break;
        case 'cambiaConfigurazioneAspetto':
            $id  = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $queryAzzeramentoImpostazioni = "UPDATE geec_configurazioniAspetto SET selezionataAdmin = 'no'";
            $geecomDb->eseguiQueryScrittura($queryAzzeramentoImpostazioni); 
            
            $querySelezioneNuovaConfigurazione = "UPDATE geec_configurazioniAspetto SET selezionataAdmin = 'si' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($querySelezioneNuovaConfigurazione);
            echo "ok";
            break;
        case 'cambiaFontConfigurazioneAspetto':
            $id         = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $linkFont   = filter_input(INPUT_POST,"linkFont",FILTER_SANITIZE_ADD_SLASHES);
            $fontTesti  = filter_input(INPUT_POST,"fontTesti",FILTER_SANITIZE_ADD_SLASHES);
            $fontIntestazioni = filter_input(INPUT_POST,"fontIntestazioni",FILTER_SANITIZE_ADD_SLASHES);
            
            $querySelezioneNuovaConfigurazione = "UPDATE geec_configurazioniAspetto SET linkFont='$linkFont', fontTesti='$fontTesti', fontIntestazioni='$fontIntestazioni' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($querySelezioneNuovaConfigurazione);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=320");
            break;
        case 'aggiornaColoriConfigurazione':
            $id                     = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $colorePrimario         = filter_input(INPUT_POST, "colorePrimario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondario       = filter_input(INPUT_POST, "coloreSecondario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccess          = filter_input(INPUT_POST, "coloreSuccess", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfo             = filter_input(INPUT_POST, "coloreInfo", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLight            = filter_input(INPUT_POST, "coloreLight", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDark             = filter_input(INPUT_POST, "coloreDark", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarning          = filter_input(INPUT_POST, "coloreWarning", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDanger             = filter_input(INPUT_POST, "coloreDanger", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioHover    = filter_input(INPUT_POST, "colorePrimarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioHover  = filter_input(INPUT_POST, "coloreSecondarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessHover     = filter_input(INPUT_POST, "coloreSuccessHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoHover        = filter_input(INPUT_POST, "coloreInfoHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightHover       = filter_input(INPUT_POST, "coloreLightHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkHover        = filter_input(INPUT_POST, "coloreDarkHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningHover        = filter_input(INPUT_POST, "coloreWarningHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerHover        = filter_input(INPUT_POST, "coloreDangerHover", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioActive   = filter_input(INPUT_POST, "colorePrimarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioActive = filter_input(INPUT_POST, "coloreSecondarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessActive    = filter_input(INPUT_POST, "coloreSuccessActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoActive       = filter_input(INPUT_POST, "coloreInfoActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightActive      = filter_input(INPUT_POST, "coloreLightActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkActive       = filter_input(INPUT_POST, "coloreDarkActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningActive    = filter_input(INPUT_POST, "coloreWarningActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerActive     = filter_input(INPUT_POST, "coloreDangerActive", FILTER_SANITIZE_ADD_SLASHES);

            $query = "UPDATE geec_configurazioniAspetto SET colorePrimario='$colorePrimario', coloreSecondario='$coloreSecondario', coloreSuccess='$coloreSuccess', coloreInfo='$coloreInfo', coloreLight='$coloreLight', coloreDark='$coloreDark', coloreWarning='$coloreWarning', coloreDanger='$coloreDanger',colorePrimarioHover='$colorePrimarioHover', coloreSecondarioHover='$coloreSecondarioHover', coloreSuccessHover='$coloreSuccessHover', coloreInfoHover='$coloreInfoHover', coloreLightHover='$coloreLightHover', coloreDarkHover='$coloreDarkHover', coloreWarningHover='$coloreWarningHover', coloreDangerHover='$coloreDangerHover', colorePrimarioActive='$colorePrimarioActive', coloreSecondarioActive='$coloreSecondarioActive', coloreSuccessActive='$coloreSuccessActive', coloreInfoActive='$coloreInfoActive', coloreLightActive='$coloreLightActive', coloreDarkActive='$coloreDarkActive', coloreWarningActive='$coloreWarningActive', coloreDangerActive='$coloreDangerActive' WHERE id=$id";
            $geecomDb->eseguiQueryLettura($query);

            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=310");
            break;        
        case 'aggiornaBreakingPointConfigurazione':
            $id                     = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $breakingPointsXs       = filter_input(INPUT_POST, "breakingPointXs", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsMd       = filter_input(INPUT_POST, "breakingPointMd", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsLg       = filter_input(INPUT_POST, "breakingPointLg", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsXl       = filter_input(INPUT_POST, "breakingPointXl", FILTER_SANITIZE_ADD_SLASHES);
            $query = "UPDATE geec_configurazioniAspetto SET breakingPointsXs='$breakingPointsXs', breakingPointsMd='$breakingPointsMd', breakingPointsLg='$breakingPointsLg', breakingPointsXl='$breakingPointsXl' WHERE id=$id";
            $geecomDb->eseguiQueryLettura($query);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=310");
            break;
        case 'clonaConfigurazione':

            $precendenteConfigurazioneColore = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataAdmin");
            
            // per prima cosatutte le configurazioni vengono impostate a no
            $query = "UPDATE geec_configurazioniAspetto SET selezionataAdmin='no'";
            $geecomDb->eseguiQueryLettura($query);
            
            $sfondoBarraMenu        = filter_input(INPUT_POST,'sfondoBarraMenu',FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestoBarraMenu   = filter_input(INPUT_POST,'coloreTestoBarraMenu',FILTER_SANITIZE_ADD_SLASHES);

            $linkFont               = filter_input(INPUT_POST,'linkFont',FILTER_SANITIZE_ADD_SLASHES);
            $fontIntestazioni       = filter_input(INPUT_POST,'fontIntestazioni',FILTER_SANITIZE_ADD_SLASHES);
            $fontTesti              = filter_input(INPUT_POST,'fontTesti',FILTER_SANITIZE_ADD_SLASHES);

            $nome                   = filter_input(INPUT_POST, "nome", FILTER_SANITIZE_ADD_SLASHES);
            $descrizione            = filter_input(INPUT_POST, "note", FILTER_SANITIZE_ADD_SLASHES);
            $colorePrimario         = filter_input(INPUT_POST, "colorePrimario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondario       = filter_input(INPUT_POST, "coloreSecondario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccess          = filter_input(INPUT_POST, "coloreSuccess", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfo             = filter_input(INPUT_POST, "coloreInfo", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLight            = filter_input(INPUT_POST, "coloreLight", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDark             = filter_input(INPUT_POST, "coloreDark", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarning          = filter_input(INPUT_POST, "coloreWarning", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDanger             = filter_input(INPUT_POST, "coloreDanger", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioHover    = filter_input(INPUT_POST, "colorePrimarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioHover  = filter_input(INPUT_POST, "coloreSecondarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessHover     = filter_input(INPUT_POST, "coloreSuccessHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoHover        = filter_input(INPUT_POST, "coloreInfoHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightHover       = filter_input(INPUT_POST, "coloreLightHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkHover        = filter_input(INPUT_POST, "coloreDarkHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningHover        = filter_input(INPUT_POST, "coloreWarningHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerHover        = filter_input(INPUT_POST, "coloreDangerHover", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioActive   = filter_input(INPUT_POST, "colorePrimarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioActive = filter_input(INPUT_POST, "coloreSecondarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessActive    = filter_input(INPUT_POST, "coloreSuccessActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoActive       = filter_input(INPUT_POST, "coloreInfoActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightActive      = filter_input(INPUT_POST, "coloreLightActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkActive       = filter_input(INPUT_POST, "coloreDarkActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningActive    = filter_input(INPUT_POST, "coloreWarningActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerActive     = filter_input(INPUT_POST, "coloreDangerActive", FILTER_SANITIZE_ADD_SLASHES);

            $breakingPointsXs       = filter_input(INPUT_POST, "breakingPointsXs", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsMd       = filter_input(INPUT_POST, "breakingPointsMd", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsLg       = filter_input(INPUT_POST, "breakingPointsLg", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsXl       = filter_input(INPUT_POST, "breakingPointsXl", FILTER_SANITIZE_ADD_SLASHES);

            $query = "INSERT INTO `geec_configurazioniAspetto` (`id`, `nome`, `descrizione`, `selezionataCms`, `selezionataAdmin`, `logo`, `logoMobile`, `favicon`, `sfondoBarraMenu`, `coloreTestoBarraMenu`, `linkFont`, `fontIntestazioni`, `fontTesti`, `colorePrimario`, `coloreSecondario`, `coloreSuccess`, `coloreInfo`, `coloreLight`, `coloreDark`, `coloreWarning`, `coloreDanger`, `colorePrimarioHover`, `coloreSecondarioHover`, `coloreSuccessHover`, `coloreInfoHover`, `coloreLightHover`, `coloreDarkHover`, `coloreWarningHover`, `coloreDangerHover`, `colorePrimarioActive`, `coloreSecondarioActive`, `coloreSuccessActive`, `coloreInfoActive`, `coloreLightActive`, `coloreDarkActive`, `coloreWarningActive`, `coloreDangerActive`, `breakingPointsXs`, `breakingPointsMd`, `breakingPointsLg`, `breakingPointsXl`)"
                    . "VALUES(NULL,'$nome','$descrizione','no','si','{$precendenteConfigurazioneColore["logo"]}','{$precendenteConfigurazioneColore["logoMobile"]}','{$precendenteConfigurazioneColore["favicon"]}','$sfondoBarraMenu','$coloreTestoBarraMenu','$linkFont','$fontIntestazioni','$fontTesti','$colorePrimario', '$coloreSecondario', '$coloreSuccess', '$coloreInfo', '$coloreLight', '$coloreDark', '$coloreWarning', '$coloreDanger','$colorePrimarioHover', '$coloreSecondarioHover', '$coloreSuccessHover', '$coloreInfoHover', '$coloreLightHover', '$coloreDarkHover', '$coloreWarningHover', '$coloreDangerHover', '$colorePrimarioActive', '$coloreSecondarioActive', '$coloreSuccessActive', '$coloreInfoActive', '$coloreLightActive', '$coloreDarkActive', '$coloreWarningActive', '$coloreDangerActive', '$breakingPointsXs', '$breakingPointsMd', '$breakingPointsLg', '$breakingPointsXl')";
            $geecomDb->eseguiQueryLettura($query);
            echo"ok";
            break;
        case 'aggiornaImpostazioniCookie':
            $idBarraCookie     = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $lingua            = filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES);
            $attivaBarraCookie = filter_input(INPUT_POST,"attivaBarraCookie",FILTER_SANITIZE_ADD_SLASHES);
            $durataCookie      = filter_input(INPUT_POST,"durataCookie",FILTER_SANITIZE_NUMBER_INT);
            $testoBarraCookie  = filter_input(INPUT_POST,"testoBarraCookie",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteAccetto    = filter_input(INPUT_POST,"testoPulsanteAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteNonAccetto = filter_input(INPUT_POST,"testoPulsanteNonAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteMaggioriInformazioni = filter_input(INPUT_POST,"testoPulsanteMaggioriInformazioni",FILTER_SANITIZE_ADD_SLASHES);
            $headCodiciCookie = filter_input(INPUT_POST,"headCodiciCookie",FILTER_SANITIZE_ADD_SLASHES);
            $fineBodyCookie   = filter_input(INPUT_POST,"fineBodyCookie",FILTER_SANITIZE_ADD_SLASHES);
            $mostraPulsanteMaggioriInformazioni = filter_input(INPUT_POST,"mostraPulsanteMaggioriInformazioni",FILTER_SANITIZE_ADD_SLASHES);
            $mostraPulsanteNonAccetto   = filter_input(INPUT_POST,"mostraPulsanteNonAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $paginaMaggioriInformazioni = filter_input(INPUT_POST,"paginaMaggioriImpostazioni",FILTER_SANITIZE_NUMBER_INT);
            $queryAggiornamentoCookie   = "UPDATE `geecAd_leggeCookie` SET `attivaBarraCookie` = '$attivaBarraCookie', `durataCookie` = '$durataCookie', `testoBarraCookie` = '$testoBarraCookie', `headCodiciCookie` = '$headCodiciCookie', `fineBodyCookie` = '$fineBodyCookie', `testoPulsanteAccetto` = '$testoPulsanteAccetto', `testoPulsanteNonAccetto` = '$testoPulsanteNonAccetto', `testoPulsanteMaggioriInformazioni` = '$testoPulsanteMaggioriInformazioni', `mostraPulsanteNonAccetto` = '$mostraPulsanteNonAccetto', `mostraPulsanteMaggioriInformazioni` = '$mostraPulsanteMaggioriInformazioni', `paginaMaggioriInformazioni` = '$paginaMaggioriInformazioni' WHERE id = $idBarraCookie;";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoCookie);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=260&lingua=$lingua");
            break;
        case 'aggiornaImpostazioniSEO':
            $testoFile         = filter_input(INPUT_POST, "contenutoFileRobots",FILTER_SANITIZE_ADD_SLASHES);
            $attivaCache       = filter_input(INPUT_POST, "attivaCache",FILTER_SANITIZE_ADD_SLASHES);
            $ottimizzazioneUrl = filter_input(INPUT_POST, "ottimizzazioneUrl",FILTER_SANITIZE_ADD_SLASHES);
            $consentiIndicizzazione = filter_input(INPUT_POST, "consentiIndicizzazione",FILTER_SANITIZE_ADD_SLASHES);

            $queryAggiornamentoPaginaContatti = "UPDATE geecAd_impostazioni SET ottimizzazioneUrl='$ottimizzazioneUrl', attivaCache='$attivaCache', consentiIndicizzazione='$consentiIndicizzazione' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            
            //scrivo il file htaccess
            $htaccess = fopen("../.htaccess", "w");
            if($impostazioni["attivaHttps"]=="si" && $ottimizzazioneUrl=="si") {
                fwrite($htaccess, GestoreHtaccess::htaccessHttpsESeo($datiInstallazioneGeecom["percorso"]).$stringaCache);
            }
            else if($ottimizzazioneUrl=="si") { 
                fwrite($htaccess, GestoreHtaccess::htaccessSeo($datiInstallazioneGeecom["percorso"]).$stringaCache);
            }
            else if($impostazioni["attivaHttps"]=="si") { 
                fwrite($htaccess, GestoreHtaccess::htaccessHttps($datiInstallazioneGeecom["percorso"]).$stringaCache);
            }
            else if($impostazioni["attivaHttps"]=="no" && $ottimizzazioneUrl=="no") {
                fwrite($htaccess, $stringaCache); // in questo caso stampa solo il valore di attiva cache dato che gli altri due valori sono impostati a no
            }
            fclose($htaccess);

            $file = fopen("../robots.txt", "w") or die("Errore nell'aprire il file robots.txt!");
            fwrite($file, $testoFile);
            fclose($file);
            
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=270");
            break;
        case 'aggiornaImpostazioniPrestazioni':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $ottimizzaImmaginiCaricate = filter_input(INPUT_POST, "ottimizzaImmaginiCaricate",FILTER_SANITIZE_ADD_SLASHES);
            $altezzaImmagine  = filter_input(INPUT_POST, "altezzaImmagine",FILTER_SANITIZE_NUMBER_INT);
            $comprimiCss      = filter_input(INPUT_POST, "comprimiCss",FILTER_SANITIZE_ADD_SLASHES);
            $comprimiJs       = filter_input(INPUT_POST, "comprimiJs",FILTER_SANITIZE_ADD_SLASHES);

            // aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoPaginaContatti = "UPDATE geecAd_impostazioni SET ottimizzaImmaginiCaricate='$ottimizzaImmaginiCaricate', altezzaImmagine=$altezzaImmagine, comprimiCss='$comprimiCss', comprimiJs='$comprimiJs' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);

            $fileCssDaCompattare = array("../plugins/hamburger/hamburgers.min.css",
                                        "../plugins/OwlCarousel2/assets/owl.carousel.min.css",
                                        "../plugins/animate/animate.css",
                                        "../plugins/universal-parallax/universal-parallax.min.css",
                                        "../plugins/aos/aos.css",
                                        "../plugins/cocoen/css/cocoen.min.css",
                                        "../plugins/ekko-lightbox/ekko-lightbox.css");
            if($comprimiCss=="si") {
                $cssUnificato = new GestoreFile("../template/cssUnificato.css","");
                $cssUnificato->importaContenutoAltriFile($fileCssDaCompattare);
                $cssUnificato->minimizzaContenuto();
                $cssUnificato->salva();
            }

            $fileJavascriptDaCompattare = array("../template/js/animateHeader.js",
                                                "../template/js/ricercaFullScreen.js",
                                                "../template/js/accordion.js",
                                                "../plugins/hamburger/hamburgers.js",
                                                "../plugins/shave/shave.js",
                                                "../template/js/scrollOnTop.js");
            if($comprimiJs=="si") {
                $jsUnificato = new GestoreFile("../template/jsUnificato.js","");
                $jsUnificato->importaContenutoAltriFile($fileJavascriptDaCompattare);
                $jsUnificato->minimizzaContenuto();
                $jsUnificato->salva();
            }
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=295");
            break;
        case 'aggiornaImpostazioniAPI':
            $attivaApi     = filter_input(INPUT_POST,"attivaApi",FILTER_SANITIZE_ADD_SLASHES);
            $emailApi      = filter_input(INPUT_POST,"emailApi",FILTER_SANITIZE_ADD_SLASHES);
            $idAppFacebook = filter_input(INPUT_POST,"idAppFacebook",FILTER_SANITIZE_ADD_SLASHES);
            $secretAppFacebook = filter_input(INPUT_POST,"secretAppFacebook",FILTER_SANITIZE_ADD_SLASHES);
            
            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoImpostazioniAPI = "UPDATE geecAd_impostazioni SET attivaApi='$attivaApi', emailApi='$emailApi', idAppFacebook='$idAppFacebook', secretAppFacebook='$secretAppFacebook' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoImpostazioniAPI);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=271");
            break;
        case 'aggiornaImpostazioniSMTP':
            $nomeMittente  = filter_input(INPUT_POST,"nomeMittente",FILTER_SANITIZE_ADD_SLASHES);
            $emailMittente = filter_input(INPUT_POST,"emailMittente",FILTER_SANITIZE_ADD_SLASHES);
            $utenteSmtp    = filter_input(INPUT_POST,"utenteSmtp",FILTER_SANITIZE_ADD_SLASHES);
            $hostSmtp      = filter_input(INPUT_POST,"hostSmtp",FILTER_SANITIZE_ADD_SLASHES);
            $portaSmtp     = filter_input(INPUT_POST,"portaSmtp",FILTER_SANITIZE_ADD_SLASHES);
            $passwordSmtp  = filter_input(INPUT_POST,"passwordSmtp",FILTER_SANITIZE_ADD_SLASHES);
            
            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoPaginaContatti = "UPDATE geecAd_impostazioni SET nomeMittente='$nomeMittente', emailMittente='$emailMittente', utenteSmtp='$utenteSmtp', hostSmtp='$hostSmtp', portaSmtp='$portaSmtp', filtraggioIP='$filtraggioIP', indirizziIPAmmessi='$indirizziIPAmmessi', indirizziIPBannati='$indirizziIPBannati', passwordSmtp='$passwordSmtp' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=275");
            break;
        case 'aggiornaImpostazioniSicurezza':
            $attivaHttps         = filter_input(INPUT_POST, "attivaHttps",FILTER_SANITIZE_ADD_SLASHES);
            $attivaFortino       = filter_input(INPUT_POST,"attivaFortino",FILTER_SANITIZE_ADD_SLASHES);
            $parolaChiaveFortino = filter_input(INPUT_POST,"parolaChiaveFortino",FILTER_SANITIZE_ADD_SLASHES);

            $filtraggioIP       = filter_input(INPUT_POST,"filtraggioIP",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPAmmessi = filter_input(INPUT_POST,"indirizziIPAmmessi",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPBannati = filter_input(INPUT_POST,"indirizziIPBannati",FILTER_SANITIZE_ADD_SLASHES);

            $filtraggioIPAreaUtenti = filter_input(INPUT_POST,"filtraggioIPAreaUtenti",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPAmmessiAreaUtenti = filter_input(INPUT_POST,"indirizziIPAmmessiAreaUtenti",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPBannatiAreaUtenti = filter_input(INPUT_POST,"indirizziIPBannatiAreaUtenti",FILTER_SANITIZE_ADD_SLASHES);

            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoPaginaContatti = "UPDATE geecAd_impostazioni SET attivaHttps='$attivaHttps', attivaFortino='$attivaFortino', parolaChiaveFortino='$parolaChiaveFortino', filtraggioIP='$filtraggioIP', indirizziIPAmmessi='$indirizziIPAmmessi', indirizziIPBannati='$indirizziIPBannati', filtraggioIPAreaUtenti='$filtraggioIPAreaUtenti', indirizziIPAmmessiAreaUtenti='$indirizziIPAmmessiAreaUtenti', indirizziIPBannatiAreaUtenti='$indirizziIPBannatiAreaUtenti' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=280");
        break;
        case 'aggiornaImpostazioniProdottiInstallati':
            $percorsoCMS   = filter_input(INPUT_POST,'percorsoCMS',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoAdmin = filter_input(INPUT_POST,'percorsoAdmin',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoAsk   = filter_input(INPUT_POST,'percorsoAsk',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoDoc   = filter_input(INPUT_POST,'percorsoDoc',FILTER_SANITIZE_ADD_SLASHES);

            $queryAggiornamento = array();
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoCMS' WHERE nome LIKE 'CMS'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoAdmin' WHERE nome LIKE 'Admin'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoAsk' WHERE nome LIKE 'Ask'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoDoc' WHERE nome LIKE 'Doc'";
            $geecomDb->eseguiInsiemeDiQuery($queryAggiornamento);
            header("Location: $percorsoGeecomAdmin/impostazioni.php?status=290");
            break;
        
            header("Location: $percorsoGeecomAdmin/creaContenuto.php?id={$datiComponente["idPagina"]}&status=350");
            break;
        case 'modificaLogo':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_configurazioniAspetto SET logo='$percorsoFoto' WHERE selezionataAdmin='si'";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'modificaLogoMobile':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_configurazioniAspetto SET logoMobile='$percorsoFoto' WHERE selezionataAdmin='si'";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'modificaFavicon':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml","image/x-icon");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_configurazioniAspetto SET favicon='$percorsoFoto' WHERE selezionataAdmin='si'";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'modificaStileCss':
            if($_FILES['file']['name']=="") { //se non c'è il file no nfa niente
                
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("text/plain","text/css");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile("stile.css");
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    echo "ok";
                }
            }
            break;
        case 'scaricaFileStileCss':
            header("Content-type: text/plain");
            header("Content-disposition: attachment; filename = stile.css");
            readfile("../template/stile.css");
            break;
        case 'scaricaFileStilePhp':
            header("Content-type: text/plain");
            header("Content-disposition: attachment; filename = stile.php");
            readfile("../template/stile.php");
            break;
        case 'modificaStilePhp':
            if($_FILES['file']['name']=="") { //se non c'è il file no fa niente
                
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("text/plain","text/x-php");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile("stile.php");
                if($esitoUpload["percorso"]=="") {
                    echo $esitoUpload["errore"];
                    exit();
                }
                else {
                    echo "ok";
                }
            }
            break;
        case 'svuotaStoricoOperazioni':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $query = "DELETE FROM geec_elementoStoricoOperazioni WHERE prodotto LIKE 'Admin'";
            $geecomDb->eseguiQueryLettura($query);
            header("Location: $percorsoGeecomAdmin/strumenti/storicoOperazioni/index.php?status=200");
            break;
    }
    
    function creaComponente($geecomDb, $idComponente, $idPagina) {
        $datiComponente = $geecomDb->leggiSingolaRiga("geecAd_componenti",$idComponente);
        
        if($datiComponente["tipo"]=="componenteDinamicoPagine" && $datiComponente["nome"]!="Visualizzatore galleria" && $datiComponente["tabellaRiferimento"]!="") {
            $datiPagina     = $geecomDb->leggiSingolaRiga("geecAd_contenuti",$idPagina);
            $nomeComponente = $geecomDb->escapeString($datiComponente["nome"]);
            $queryInserimento = "INSERT INTO {$datiComponente["tabellaRiferimento"]} (`id`,`nome`) VALUES(NULL,'$nomeComponente pagina {$datiPagina["titolo"]}')";
            return $geecomDb->eseguiQueryCreazione($queryInserimento);            
        }
        else if($datiComponente["nome"]=="Immagine") {
            $immagine = new Immagine($geecomDb, 0, $idPagina, "immagineContenuto");
            return $immagine->crea();
        }
        else {
            return 0;
        }
    }
